using System;
using System.Windows.Forms;
using System.IO;
using Borland.Studio.ToolsAPI;
using BeWise.SharpBuilderTools.Utils;

namespace BeWise.SharpBuilderTools
{
	public class OTACodeBeautifier : BaseOTA
	{

		/**************************************************************/
		/*                        Protected
		/**************************************************************/

		protected string GetAStyleExe(){
			string _Path = Main.Configuration.AStylePath;

			if (_Path[_Path.Length -1] != '\\') {
				_Path += @"\";
			}

			_Path += Consts.ASTYLE_EXE_NAME;

			return _Path;
		}

		protected void DoCodeBeautify(object aSender, EventArgs AEventArgs)
		{
			if (Main.Configuration.AStylePath == "" || !File.Exists(GetAStyleExe())) {
				MessageBox.Show("Please configure correctly Sharp Builder Tools!", Consts.MESSAGE_BOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Information);
			}
			else if (!OTAUtils.CurrentModuleIsCSFile()) {
				MessageBox.Show("Code beautifier only apply to C# files !", Consts.MESSAGE_BOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Information);
			}
			else {
				IOTAModuleServices _ModuleServices = (IOTAModuleServices) BorlandIDE.GetService(typeof(IOTAModuleServices));
				IOTAModule _Module = _ModuleServices.CurrentModule;

				IOTAEditor _Editor = OTAUtils.GetEditorWithSourceEditor(_ModuleServices.CurrentModule);

				if (_Editor != null && !_Editor.IsModified) {
					IOTASourceEditor _SourceEditor = OTAUtils.GetSourceEditor(_ModuleServices.CurrentModule);

					RunProcess _RP = new RunProcess();
					string[] _Arr = new string[2];

					_Arr[0] = GetAStyleExe();
					_Arr[1] = Main.Configuration.AStyleParams + @" """ + _Module.FileName + @"""";

					_RP.Run(_Arr, Path.GetDirectoryName(_Module.FileName));

					IOTAActionService _ActionService = (IOTAActionService) BorlandIDE.GetService(typeof(IOTAActionService));
					_ActionService.ReloadFile(_Module.FileName);

				}
				else {
					MessageBox.Show("Save your file before applying the code beautifier!", Consts.MESSAGE_BOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Information);
				}
			}
		}

		/**************************************************************/
		/*                        Public
		/**************************************************************/

		public override void IDERegister(out string[] aMenuNames, out int[] aMenuShortCuts) {
			IOTAMainMenuService _MenuService = null;
			IOTAMenuItem _MenuItem = null;

			_MenuService = (IOTAMainMenuService) BorlandIDE.GetService(typeof(IOTAMainMenuService));

			// Sep
			_MenuItem = _MenuService.AddMenuItem(Consts.SHARP_BUILDER_TOOLS_MENU_NAME, OTAMenuItemLocation.otamlChild, "SepBeautifierMenu2","-");

            // Code Beautifier
			_MenuItem = _MenuService.AddMenuItem(Consts.SHARP_BUILDER_TOOLS_MENU_NAME, OTAMenuItemLocation.otamlChild, "CodeBeautifierMenu", "Code Beautifier");
			_MenuItem.Enabled = true;
			_MenuItem.Executed += new EventHandler(DoCodeBeautify);

			aMenuNames = new string[] {"CodeBeautifierMenu"};
			aMenuShortCuts = new int[] {16450}; // Ctrl B
		}
	}
}
